#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);

	int t = 1;
	//cin >> t;
	while(true) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

struct vert {
	int go[2];
	int ends;
	int num;
	vert():ends(0) {
		memset(go, 255, sizeof(go));
	}
};

vector <vert> tree;

void init() {
	tree.clear();
	tree.push_back(vert());
}

int getV(const vector <int>& a, bool doCreate) {
	int v = 0;
	for (int i = 0; i < a.size(); ++i) {
		if (tree[v].go[a[i]] == -1) {
			if (doCreate) {
				tree[v].go[a[i]] = tree.size();
				tree.push_back(vert());
			}
			else {
				return -1;
			}
		}
		v = tree[v].go[a[i]];
	}
	return v;
}

void setB(int v, int num) {
	if (v == -1) {
		return;
	}

	++tree[v].ends;
	if (tree[v].ends == 1) {
		tree[v].num = num;
	}
	else {
		tree[v].num = -1;
	}
}

char getFuck(int x) {
	if (x < 10) {
		return '0' + x;
	}
	x -= 10;
	return 'A' + x;
}

void solve() {
	int n[2], q;
	cin >> n[0] >> n[1] >> q;
	if (n[0] == 0) {
		exit(0);
	}
	
	vector <int> on[2];
	vector < vector <int> > a[2];

	for (int i = 0; i < 2; ++i) {
		on[i].resize(n[i]);
		a[i].resize(n[i]);
	}

	

	
	for (int i = 0; i < q; ++i) {
		on[1].assign(n[1], 0);

		for (int j = 0; j < 2; ++j) {
			string s;
			cin >> s;
			for (int t = 0; t < n[j]; ++t) {
				if (s[t] == '1') {
					on[j][t] ^= 1;		
				}
			}
		}

		for (int j = 0; j < 2; ++j) {
			for (int t = 0; t < n[j]; ++t) {
				a[j][t].push_back(on[j][t]);
			}
		}
	}


	init();

	for (int i = 0; i < n[0]; ++i) {
		int v = getV(a[0][i], true);
		setB(v, i);
	}

	for (int i = 0; i < n[1]; ++i) {
		int v = getV(a[1][i], false);
		if (v == -1) {
			//assert(false);
		}
		if (tree[v].ends != 1) {
			cout << "?";
		}
		else {
			cout << getFuck(tree[v].num);
		}
	}
	cout << "\n";
}